﻿/*
VERSION:		1.7
1.7		Split code into "checkAllFlags.as" and "checkFlag.as" to enable flag-evaluation for other purposes
1.6		Use "getPathValue.as" to read variable paths

DESCRIPTION:
	Places and removes sprites based on their flag conditions.
	This can also be used to initially place sprites when a level is loaded.

USAGE:
	// remember all sprites in a new array
	sprites_mc.spritesRemaining = [];
	for(var s=0; s<levelData.sprites.length; s++){
		sprites_mc.spritesRemaining.push( levelData.sprites[s] );
	}// for:  each spriteData
	sprites_mc.spritesRemaining.remove = function( thisSprite )
	{// remove()
		for(var s in sprites_mc.spritesRemaining){
			if(sprites_mc.spritesRemaining[s] == thisSprite){
				sprites_mc.spritesRemaining.splice( s, 1 );
			}// if:  targeted sprite is found
		}// for:  each remaining sprite
	}// remove()
	// call  spritesRemaining.remove()  when a sprite is removed from play
	
	
	#include "functions/updateFlaggedSprites.as"
	#include "functions/nextDepth.as"
	sprites_mc.updateSprites = function( focusOnFlag ){
		var addSprite = function( thisSprite ){
			if(sprites_mc[thisSprite.name] == undefined)
			{// if:  this sprite doesn't exist
				var type = thisSprite.type;
				var newName = thisSprite.name;
				var newDepth = nextDepth(sprites_mc);
				var newX = thisSprite.position.x;
				var newY = thisSprite.position.y;
				var settings = thisSprite.data;
				var newSprite = sprites_mc.attachMovie(type, newName, newDepth, {_x:newX, _y:newY, data:thisSprite, settings:settings});
				newSprite.remove = function(){// remove()
					sprites_mc.spritesRemaining.remove( this.data );
					this.removeMovieClip();
				}// remove()
			}// if:  this sprite doesn't exist
		}// addSprite()
		var removeSprite = function( thisSprite ){
			sprites_mc[thisSprite.name].removeMovieClip();
		}// removeSprite()
		var showSprites = updateFlaggedSprites( sprites_mc.spritesRemaining, ram, addSprite, removeSprite, focusOnFlag );
	}// updateSprites()

	
	
	
	
POSSIBLE DISPLAY VALUES:
	myFlag
	!myFlag
	myFlag = undefined		(same as not including it)
	myFlag = true
	myFlag != 10
	myFlag = ""
	myFlag = "merf"
	myFlag = 0
	myFlag > -1
	myFlag < -77
	myFlag >= 4
	myFlag <= 17
	myObj.anotherObject.myFlag = 973
	
POSSIBLE FLAG VALUES:
	myFlag
	!myFlag
	myFlag = undefined		(not whether it's false, whether it's nonexistant)
	myFlag = true
	myFlag != 10
	myFlag = ""
	myFlag = "merf"
	myFlag = 0
	myFlag > -1
	myFlag < -77
	myFlag >= 4
	myFlag <= 17
	myObj.anotherObject.myFlag = 973

PARAMETERS:
	sprites				Array of sprite data  (not movieClips)
	flagRoot			Object containing all the flag variables & their sub-objects
	addSprite			function to run when a sprite's flags are all true  (Might run more than once)
	removeSprite	function to run when one of a sprite's flags is false and it should no longer exist  (Might run more than once)
*/
//#include "getPathValue.as"
//#include "nestedEval.as"
function updateFlaggedSprites( sprites, flagRoot, addSprite, removeSprite )
{
	#include "checkFlag.as"
	#include "checkAllFlags.as"
	// _______________________________________________________________________________
	
	
	
	
	// check sprites
	for( var s=0; s<sprites.length; s++)
	{// for:  each sprite
		var thisSprite = sprites[s];
//		trace("sprite: "+thisSprite.name);
		
		var testResult = checkAllFlags( thisSprite.flags, flagRoot );
		
		if(testResult==true){						// add
			addSprite( thisSprite );
		}else if(testResult==false){		// remove
			removeSprite( thisSprite );
		}
	}// for:  each sprite
}// updateFlaggedSprites()